﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Domaine;

namespace Persistance
{
    /// <summary>
    /// Classe abstraite regroupant tous les traitements permettant d'accéder aux données persistantes
    /// Doit être héritée pour définir comment les données sont accédées
    /// </summary>
    public abstract class AccesDonnees
    {
        /// <summary>
        /// Récupère la liste des utilisateurs de la bibliothèque
        /// </summary>
        /// <returns></returns>
        public abstract List<Utilisateur> GetUtilisateurs();

        /// <summary>
        /// Récupère la liste des livres de la bibliothèque
        /// </summary>
        /// <returns></returns>
        public abstract List<Livre> GetLivres();

        /// <summary>
        /// Récupère la liste des livres mepruntables (non empruntés)
        /// </summary>
        /// <returns></returns>
        public abstract List<Livre> GetLivresEmpruntables();

        /// <summary>
        /// Récupère la liste des meprunts
        /// </summary>
        /// <returns></returns>
        public abstract List<Emprunt> GetEmprunts();

        /// <summary>
        /// Récupère la liste des meprunts non rendus (empruntés)
        /// </summary>
        /// <returns></returns>
        public abstract List<Emprunt> GetEmpruntsNonRendus();

        /// <summary>
        /// Mémorise un nouvel emprunt
        /// </summary>
        /// <param name="emprunt">le nouvel emprunt</param>
        public abstract void Ajouter(Emprunt emprunt);

        /// <summary>
        /// Mémorise le retour d'un emprunt
        /// </summary>
        /// <param name="emprunt">l'emprunt rendu</param>
        public abstract void EnregistrerRetour(Emprunt emprunt);

        /// <summary>
        /// Mémorise un nouvel utilisateur
        /// </summary>
        /// <param name="nom">Le nom du nouvel utilisateur</param>
        /// <param name="prenom">Le prénom du nouvel utilisateur</param>
        public abstract void EnregistrerUtilisateur(Utilisateur utilisateur);

        /// <summary>
        /// Mémorise un nouveau livre
        /// </summary>
        /// <param name="ISBN">ISBN du nouveau livre</param>
        /// <param name="titre">Titre du nouveau livre</param>
        /// <param name="auteur">Auteur du nouveau livre</param>
        public abstract void EnregistrerLivre(Livre livre);
    }
}
